﻿using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Create
{
    /// <summary>
    /// Get Integration Settings step.
    /// </summary>
    public class GetIntegrationSettingsStep : FilterBase<VideoVisitCreateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VideoVisitCreateStateObject state)
        {
            using (var context = new Xrm(state.OrganizationServiceProxy))
            {
                var fakeType = context.mcs_integrationsettingSet.FirstOrDefault(x => x.mcs_name == "Vista Fake Response Type");
                state.VistaFakeResponseType = fakeType != null ? fakeType.mcs_value : string.Empty;
            }
        }
    }
}